# Code to train networks with gradient based orbit mapping for rotation invariant CIFAR10 classification

## Usage:

**To train and test Resnet18 on CIFAR10 using gradient based orbit mapping:**

``python train_test_cifar.py --gradalign --net Resnet18 --lr 0.1``

**To train Resnet18 on CIFAR10 using gradient based orbit mapping, with rotation augmentation:**

``python train_test_cifar.py --gradalign --net Resnet18 --lr 0.1 --augment 'rot-default'``

**For standard training of Resnet18 on CIFAR10**

``python train_test_cifar.py``



**Arguments**

``--net`` network architecture, one of ``'Resnet18'``, ``'convnet'``, ``'linear'``

``--lr`` learning rate default is ``0.1``. Choose ``0.01`` for ``'convnet'``, ``'linear'``

``--augment`` augmentation, one of ``'standard'``, ``'rot-default'``, ``'combi-rot'``

Specify ``--gradalign`` for gradient based orbit mapping

``--eval_mode`` interpolation used to rotate images, default ``None`` evaluates 3 interpolation modes ``'bilinear'``,``'bicubic'``, ``'nearest'``




